<?php

namespace App\Models;

use App\User;
use Carbon\Carbon;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sell extends Model
{
    use SoftDeletes;

    protected $dates = ['sell_date'];

    protected $fillable = ['sub_total', 'discount','grand_total_price','due_amount', 'payment_type', 'card_information'];

    public function sellProducts()
    {
        return $this->hasMany(SellProduct::class)->with('product');
    }

    public function branch()
    {
        return $this->belongsTo(Branch::class)->withTrashed();
    }

    public function customer()
    {
        return $this->belongsTo(Customer::class)->withTrashed();
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    protected static function boot()
    {
        parent::boot(); // TODO: Change the autogenerated stub
        self::creating(function($model){
            $model->created_by =  auth()->user()->id;
            $model->sell_date =  Carbon::now();
            $model->branch_id =  auth()->user()->employee->branch_id;
            $model->invoice_id = get_option('sell_invoice_prefix').str_pad(Sell::withTrashed()->count()+1,get_option('invoice_length'),0,STR_PAD_LEFT);
        });
    }
}
